ORCA/M Asm65816 2.1.0

0001 212C                       title 'QD UTILS             GS ROM 2.0'
0002 212C              ****************************************************************
0003 212C              *                                                              *
0004 212C              *              UTILS                                           *
0005 212C              *                                                              *
0006 212C              ****************************************************************
0007 212C
0008 212C
0009 212C              ****************************************************************
0010 212C              *                                                              *
0011 212C              *                   Copyright (C) 1985-1987                    *
0012 212C              *                   All Rights Reserved                        *
0013 212C              *                   Apple Computer, Inc.                       *
0014 212C              *                                                              *
0015 212C              ****************************************************************
0016 212C
0017 212C                       string asis 
0018 212C                       blanks off 
0019 212C
0020 212C
0021 212C                       include 'all.macros' 
0022 212C
0023 212C                       include ':QDEquates:qd.data.asm' 
0024 212C
0025 212C                       INCLUDE ':QDEquates:core.globals1' 
0026 212C                       INCLUDE ':QDEquates:core.globals2' 
0027 212C
0028 212C
0029 212C              ;-----------------------------------------------
0030 212C              ;
0031 212C              ;   Imported addresses
0032 212C              ;
0033 212C              ;-----------------------------------------------
0034 212C
0035 212C                       IMPORT BusyEC0 
0036 212C                       IMPORT BusyEC4 
0037 212C                       IMPORT EndCall12 
0038 212C                       IMPORT EndCall4 
0039 212C                       IMPORT EndCall8 
0040 212C                       IMPORT QDStart 
0041 212C                       IMPORT oEndCall12 
0042 212C
0043 212C
0044 212C              ;                COPY UTILS/UTILS
0045 212C              ****************************************************************
0046 212C              *
0047 212C              * Utilities for the Core Routines
0048 212C              *
0049 212C              ****************************************************************
0050 212C
0051 212C              ****************************************************************
0052 212C              *
0053 212C              * SetRect (RPtr : ptr; Left,Top,Right,Bottom : integer)
0054 212C              *
0055 212C              * This is a glue routine in QuickDraw that for Pascal takes
0056 212C              * four integers off the stack and puts them in a rectangle.
0057 212C              *
0058 212C              ****************************************************************
0059 212C                       EXPORT SetRect 
0060 212C              SetRect  PROC 
0061 212C              RTL1     equ 1 
0062 212C              RTL2     equ RTL1+3 
0063 212C              Bottom   equ RTL2+3 
0064 212C              Right    equ Bottom+2 
0065 212C              Top      equ Right+2 
0066 212C              Left     equ Top+2 
0067 212C              RPtr     equ Left+2 
0068 212C
0069 212C 3B                    tsc                            ; get stack
0070 212D 0B                    phd                            ; save d
0071 212E 5B                    tcd                            ; set stack to zp
0072 212F
0073 212F A5 0B                 lda   Top
0074 2131 87 0F                 sta   [RPtr]
0075 2133 A0 02 00              ldy   #2
0076 2136 A5 0D                 lda   Left
0077 2138 97 0F                 sta   [RPtr],y
0078 213A C8                    iny   
0079 213B C8                    iny   
0080 213C A5 07                 lda   Bottom
0081 213E 97 0F                 sta   [RPtr],y
0082 2140 C8                    iny   
0083 2141 C8                    iny   
0084 2142 A5 09                 lda   Right
0085 2144 97 0F                 sta   [RPtr],y
0086 2146
0087 2146 4C 66 FC              jmp   EndCall12
0088 2149
0089 2149                       ENDP 
0090 2149
0091 2149
0092 2149
0093 2149              ****************************************************************
0094 2149              *
0095 2149              * OffsetRect (RPtr : ptr; dh, dv : integer);
0096 2149              *
0097 2149              ****************************************************************
0098 2149                       EXPORT OffsetRect 
0099 2149              OffsetRect PROC 
0100 2149              *              using CoreDATA
0101 2149              RTL1     equ 1 
0102 2149              RTL2     equ RTL1+3 
0103 2149              OffsetY  equ RTL2+3 
0104 2149              OffsetX  equ OffsetY+2 
0105 2149              PointerToRect equ OffsetX+2 
0106 2149
0107 2149 3B                    tsc                            ; get stack
0108 214A 0B                    phd                            ; save direct
0109 214B 5B                    tcd                            ; set direct to stack
0110 214C
0111 214C
0112 214C A0 06 00              ldy   #6
0113 214F
0114 214F B7 0B        Loop     lda   [PointerToRect],y
0115 2151 18                    clc   
0116 2152 65 09                 adc   OffsetX
0117 2154 97 0B                 sta   [PointerToRect],y
0118 2156
0119 2156 88                    dey   
0120 2157 88                    dey   
0121 2158
0122 2158 B7 0B                 lda   [PointerToRect],y
0123 215A 18                    clc   
0124 215B 65 07                 adc   OffsetY
0125 215D 97 0B                 sta   [PointerToRect],y
0126 215F
0127 215F 88                    dey   
0128 2160 88                    dey   
0129 2161
0130 2161 10 EC                 bpl   Loop
0131 2163
0132 2163 4C 3A FC              jmp   EndCall8
0133 2166
0134 2166                       ENDP 
0135 2166
0136 2166
0137 2166              ****************************************************************
0138 2166              *
0139 2166              * InsetRect (RPtr : ptr; dh, dv : integer);
0140 2166              *
0141 2166              * Takes the rectange adds the point the top/left and subracts
0142 2166              * the point from the bottom right.
0143 2166              *
0144 2166              ****************************************************************
0145 2166                       EXPORT InsetRect 
0146 2166              InsetRect PROC 
0147 2166              *              using CoreDATA
0148 2166              RTL1     equ 1 
0149 2166              RTL2     equ RTL1+3 
0150 2166              OffsetY  equ RTL2+3 
0151 2166              OffsetX  equ OffsetY+2 
0152 2166              PointerToRect equ OffsetX+2 
0153 2166
0154 2166
0155 2166 3B                    tsc                            ; get stack
0156 2167 0B                    phd                            ; save direct
0157 2168 5B                    tcd                            ; set direct page to stack
0158 2169
0159 2169
0160 2169 A7 0B                 lda   [PointerToRect]
0161 216B 18                    clc   
0162 216C 65 07                 adc   OffsetY
0163 216E 87 0B                 sta   [PointerToRect]
0164 2170
0165 2170 A0 02 00              ldy   #2
0166 2173 B7 0B                 lda   [PointerToRect],y
0167 2175 18                    clc   
0168 2176 65 09                 adc   OffsetX
0169 2178 97 0B                 sta   [PointerToRect],y
0170 217A
0171 217A
0172 217A C8                    iny   
0173 217B C8                    iny   
0174 217C B7 0B                 lda   [PointerToRect],y
0175 217E 38                    sec   
0176 217F E5 07                 sbc   OffsetY
0177 2181 97 0B                 sta   [PointerToRect],y
0178 2183
0179 2183 C8                    iny   
0180 2184 C8                    iny   
0181 2185
0182 2185 B7 0B                 lda   [PointerToRect],y
0183 2187 38                    sec   
0184 2188 E5 09                 sbc   OffsetX
0185 218A 97 0B                 sta   [PointerToRect],y
0186 218C
0187 218C 4C 3A FC              jmp   EndCall8
0188 218F
0189 218F                       ENDP 
0190 218F
0191 218F
0192 218F              ****************************************************************
0193 218F              *
0194 218F              * SectRect (SrcAPtr, SrcBPtr : ptr; DestPtr : ptr) : boolean
0195 218F              *
0196 218F              * Params
0197 218F              *     input   long    R1 Pointer
0198 218F              *     input   long    R2 Pointer
0199 218F              *     input   long    Result Pointer
0200 218F              *     output  word?   boolean
0201 218F              *
0202 218F              * Calculates the intersection of R1 and R2 and puts the
0203 218F              * result in Result Rect
0204 218F              *
0205 218F              ****************************************************************
0206 218F                       EXPORT SectRect 
0207 218F              SectRect PROC 
0208 218F              *              using CoreDATA
0209 218F              RTL1     equ 1 
0210 218F              RTL2     equ RTL1+3 
0211 218F              ResultPointer equ RTL2+3 
0212 218F              R2Pointer equ ResultPointer+4 
0213 218F              R1Pointer equ R2Pointer+4 
0214 218F              Result   equ R1Pointer+4 
0215 218F
0216 218F 3B                    tsc                            ; get stack
0217 2190 0B                    phd                            ; save direct
0218 2191 5B                    tcd                            ; set direct to stack
0219 2192
0220 2192 A0 02 00              ldy   #2
0221 2195 B7 0F        Loop1    lda   [R1Pointer],y            ; compare the two top/left points
0222 2197 D7 0B                 cmp   [R2Pointer],y            ; take larger
0223 2199 10 02                 bpl   GotLarger
0224 219B B7 0B                 lda   [R2Pointer],y
0225 219D 97 07        GotLarger sta   [ResultPointer],y
0226 219F 88                    dey   
0227 21A0 88                    dey   
0228 21A1 10 F2                 bpl   Loop1
0229 21A3
0230 21A3 A0 06 00              ldy   #6
0231 21A6 B7 0F        Loop2    lda   [R1Pointer],y            ; compare the two bot/right points
0232 21A8 D7 0B                 cmp   [R2Pointer],y
0233 21AA 30 02                 bmi   GotSmaller
0234 21AC B7 0B                 lda   [R2Pointer],y
0235 21AE 97 07        GotSmaller sta   [ResultPointer],y
0236 21B0 88                    dey   
0237 21B1 88                    dey   
0238 21B2 C0 03 00              cpy   #3
0239 21B5 10 EF                 bpl   Loop2
0240 21B7
0241 21B7 A0 04 00              ldy   #4
0242 21BA A7 07                 lda   [ResultPointer]
0243 21BC D7 07                 cmp   [ResultPointer],y
0244 21BE 10 13                 bpl   ABadRect
0245 21C0
0246 21C0 88                    dey   
0247 21C1 88                    dey   
0248 21C2 B7 07                 lda   [ResultPointer],y
0249 21C4 A0 06 00              ldy   #6
0250 21C7 D7 07                 cmp   [ResultPointer],y
0251 21C9 10 08                 bpl   ABadRect
0252 21CB
0253 21CB
0254 21CB A9 FF FF              lda   #TRUE                    ; put true in a-reg
0255 21CE 85 13        AllDone  sta   Result
0256 21D0
0257 21D0 4C 66 FC              jmp   EndCall12
0258 21D3
0259 21D3 A9 00 00     ABadRect lda   #FALSE                   ; zero the dest rect
0260 21D6 A0 06 00              ldy   #6
0261 21D9 97 07        Loop4    sta   [ResultPointer],y
0262 21DB 88                    dey   
0263 21DC 88                    dey   
0264 21DD 10 FA                 bpl   Loop4
0265 21DF 80 ED                 bra   AllDone                  ; A-reg has false flag
0266 21E1
0267 21E1                       ENDP 
0268 21E1
0269 21E1
0270 21E1              ****************************************************************
0271 21E1              *
0272 21E1              * UnionRect (SrcAPtr, SrcBPtr : ptr; DestPtr : ptr)
0273 21E1              *
0274 21E1              * Params
0275 21E1              *     input      long     R1 Pointer
0276 21E1              *     input      long     R2 Pointer
0277 21E1              *     input      long     Result Pointer
0278 21E1              *
0279 21E1              * Calculates the union of R1 and R2 and puts the
0280 21E1              * result in Result Rect
0281 21E1              *
0282 21E1              ****************************************************************
0283 21E1                       EXPORT UnionRect 
0284 21E1              UnionRect PROC 
0285 21E1              *              using CoreDATA
0286 21E1              RTL1     equ 1 
0287 21E1              RTL2     equ RTL1+3 
0288 21E1              ResultPointer equ RTL2+3 
0289 21E1              R2Pointer equ ResultPointer+4 
0290 21E1              R1Pointer equ R2Pointer+4 
0291 21E1
0292 21E1 3B                    tsc                            ; get stack
0293 21E2 0B                    phd                            ; save direct register
0294 21E3 5B                    tcd                            ; set direct to stack
0295 21E4
0296 21E4 A0 02 00              ldy   #2
0297 21E7 B7 0F        Loop1    lda   [R1Pointer],y            ; compare the two top/left points
0298 21E9 D7 0B                 cmp   [R2Pointer],y            ; and keep the smaller one
0299 21EB 30 02                 bmi   GotSmaller
0300 21ED B7 0B                 lda   [R2Pointer],y
0301 21EF 97 07        GotSmaller sta   [ResultPointer],y
0302 21F1 88                    dey   
0303 21F2 88                    dey   
0304 21F3 10 F2                 bpl   Loop1
0305 21F5
0306 21F5 A0 06 00              ldy   #6
0307 21F8 B7 0F        Loop2    lda   [R1Pointer],y            ; compare the two bot/right points
0308 21FA D7 0B                 cmp   [R2Pointer],y            ; and keep the bigger one
0309 21FC 10 02                 bpl   GotBigger
0310 21FE B7 0B                 lda   [R2Pointer],y
0311 2200 97 07        GotBigger sta   [ResultPointer],y
0312 2202 88                    dey   
0313 2203 88                    dey   
0314 2204 C0 03 00              cpy   #3
0315 2207 10 EF                 bpl   Loop2
0316 2209
0317 2209
0318 2209 4C 66 FC              jmp   EndCall12
0319 220C
0320 220C                       ENDP 
0321 220C
0322 220C
0323 220C
0324 220C              ****************************************************************
0325 220C              *
0326 220C              * PtInRect ( PPtr : ptr; RPtr: ptr) : boolean
0327 220C              *
0328 220C              * Params
0329 220C              *     input     long    R  Pointer
0330 220C              *     input     long    P  Pointer
0331 220C              *     output    word?   boolean
0332 220C              *
0333 220C              * Determines if Point is in rectangle
0334 220C              * result in Result Rect
0335 220C              *
0336 220C              * Modification History
0337 220C              *
0338 220C              *   27 May 86  The test for the Y value of the point
0339 220C              *              being less than the bottom used a BCS
0340 220C              *              instead of a BPL.
0341 220C              *
0342 220C              ****************************************************************
0343 220C                       EXPORT PtInRect 
0344 220C              PtInRect PROC 
0345 220C              *              using CoreDATA
0346 220C              RTL1     equ 1 
0347 220C              RTL2     equ RTL1+3 
0348 220C              RectPtr  equ RTL2+3 
0349 220C              PtPtr    equ RectPtr+4 
0350 220C              Result   equ PtPtr+4 
0351 220C
0352 220C
0353 220C 3B                    tsc                            ; get stack
0354 220D 0B                    phd                            ; save direct
0355 220E 5B                    tcd                            ; set direct to stack
0356 220F
0357 220F
0358 220F A7 0B                 lda   [PtPtr]
0359 2211 C7 07                 cmp   [RectPtr]
0360 2213 30 1E                 bmi   BadPoint
0361 2215 A0 04 00              ldy   #4
0362 2218 D7 07                 cmp   [RectPtr],y
0363 221A 10 17                 bpl   BadPoint                 ; signed compare on 27 May 86
0364 221C 88                    dey   
0365 221D 88                    dey   
0366 221E B7 0B                 lda   [PtPtr],y
0367 2220 D7 07                 cmp   [RectPtr],y
0368 2222 30 0F                 bmi   BadPoint
0369 2224 A0 06 00              ldy   #6
0370 2227 D7 07                 cmp   [RectPtr],y
0371 2229 10 08                 bpl   BadPoint
0372 222B
0373 222B A9 FF FF              lda   #TRUE
0374 222E 85 0F        AllDone  sta   Result
0375 2230
0376 2230
0377 2230 4C 3A FC              jmp   EndCall8
0378 2233
0379 2233 A9 00 00     BadPoint lda   #FALSE
0380 2236 80 F6                 bra   AllDone
0381 2238
0382 2238                       ENDP 
0383 2238
0384 2238
0385 2238              ****************************************************************
0386 2238              *
0387 2238              * Pt2Rect (PtAPtr, PtBPtr : Ptr; RPtr : Ptr);
0388 2238              *
0389 2238              *      input     long     Ptr to PtA
0390 2238              *      input     long     Ptr to Ptb
0391 2238              *      input     long     Ptr to Result Rect
0392 2238              *
0393 2238              * This is another QuickDraw routine that is glue for Pascal.
0394 2238              *
0395 2238              ****************************************************************
0396 2238                       EXPORT Pt2Rect 
0397 2238              Pt2Rect  PROC 
0398 2238              RTL1     equ 1 
0399 2238              RTL2     equ RTL1+3 
0400 2238              RPtr     equ RTL2+3 
0401 2238              BPtr     equ RPtr+4 
0402 2238              APtr     equ BPtr+4 
0403 2238
0404 2238 3B                    tsc                            ; get stack
0405 2239 0B                    phd                            ; save d
0406 223A 5B                    tcd                            ; set stack to zp
0407 223B
0408 223B A7 0F                 lda   [APtr]                   ; get y of point a
0409 223D 87 07                 sta   [RPtr]                   ; put it in rect
0410 223F A0 02 00              ldy   #2                       ; get x of point a
0411 2242 B7 0F                 lda   [APtr],y                 ; put it in rect
0412 2244 97 07                 sta   [RPtr],y                 ;
0413 2246
0414 2246 B7 0B                 lda   [BPtr],y                 ; get X of point b
0415 2248 A0 06 00              ldy   #6                       ; put it in rect
0416 224B 97 07                 sta   [RPtr],y                 ;
0417 224D A7 0B                 lda   [BPtr]                   ; get Y of point b
0418 224F 88                    dey   
0419 2250 88                    dey   
0420 2251 97 07                 sta   [RPtr],y                 ; put it in rect
0421 2253
0422 2253 4C 66 FC              jmp   EndCall12
0423 2256
0424 2256                       ENDP 
0425 2256
0426 2256
0427 2256
0428 2256              ****************************************************************
0429 2256              *
0430 2256              * PtToAngle
0431 2256              *
0432 2256              * This is a weird QuickDraw call handy to use with arcs and
0433 2256              * wedges, which Cary Clark thinks we should not support.
0434 2256              *
0435 2256              ****************************************************************
0436 2256
0437 2256
0438 2256
0439 2256              ****************************************************************
0440 2256              *
0441 2256              * EqualRect   (r1Ptr,r2Ptr : ptr) : boolean;
0442 2256              *
0443 2256              * Params
0444 2256              *     input      long    R1 Pointer
0445 2256              *     input      long    R2 Pointer
0446 2256              *     output     word?   boolean
0447 2256              *
0448 2256              * Determines if two rectangles are equal
0449 2256              * result in Result Rect
0450 2256              *
0451 2256              ****************************************************************
0452 2256                       EXPORT EqualRect 
0453 2256              EqualRect PROC 
0454 2256              *              using CoreDATA
0455 2256
0456 2256              RTL1     equ 1 
0457 2256              RTL2     equ RTL1+3 
0458 2256              R1Ptr    equ RTL2+3 
0459 2256              R2Ptr    equ R1Ptr+4 
0460 2256              Result   equ R2Ptr+4 
0461 2256
0462 2256 3B                    tsc                            ; get stack
0463 2257 0B                    phd                            ; save direct
0464 2258 5B                    tcd                            ; transfer stack to direct
0465 2259
0466 2259 A0 06 00              ldy   #6
0467 225C B7 07        Loop     lda   [R1Ptr],y
0468 225E D7 0B                 cmp   [R2Ptr],y
0469 2260 D0 0C                 bne   NotEqual
0470 2262 88                    dey   
0471 2263 88                    dey   
0472 2264 10 F6                 bpl   Loop
0473 2266
0474 2266 A9 FF FF              lda   #TRUE                    ; put true in a-reg
0475 2269 85 0F        AllDone  sta   Result
0476 226B
0477 226B 4C 3A FC              jmp   EndCall8
0478 226E
0479 226E A9 00 00     NotEqual lda   #FALSE                   ; zero the dest rect
0480 2271 80 F6                 bra   AllDone
0481 2273
0482 2273                       ENDP 
0483 2273
0484 2273
0485 2273              ****************************************************************
0486 2273              *
0487 2273              * NotEmptyRect (RPtr : Ptr) : boolean;
0488 2273              *
0489 2273              * Params
0490 2273              *     input     long    Rect Pointer
0491 2273              *     output    word?   boolean
0492 2273              *
0493 2273              * Determines if rectangle is empty.  Empty is defined by
0494 2273              * the top/left being greater than or equal to the bot/right.
0495 2273              *
0496 2273              * Modification History
0497 2273              *
0498 2273              * 31 Dec 86    SEG
0499 2273              *
0500 2273              *    Was returning true when not empty and false when empty instead
0501 2273              *    of right way.
0502 2273              *
0503 2273              * 05 Feb 87    SEG
0504 2273              *
0505 2273              *    Making this call match the specification caused software
0506 2273              *    to stop working.  We now redefine the call to be
0507 2273              *
0508 2273              *                    NotEmptyRect
0509 2273              *
0510 2273              *    It returns true when the rect is not empty and false if it
0511 2273              *    is empty.
0512 2273              *
0513 2273              ****************************************************************
0514 2273                       EXPORT NotEmptyRect 
0515 2273              NotEmptyRect PROC 
0516 2273              *              using CoreDATA
0517 2273
0518 2273              RTL1     equ 1 
0519 2273              RTL2     equ RTL1+3 
0520 2273              RPtr     equ RTL2+3 
0521 2273              Result   equ RPtr+4 
0522 2273
0523 2273 3B                    tsc                            ; get stack
0524 2274 0B                    phd                            ; save direct
0525 2275 5B                    tcd                            ; set direct to stack
0526 2276
0527 2276 A0 00 00              ldy   #0
0528 2279 B7 07        Loop     lda   [RPtr],y
0529 227B C8                    iny   
0530 227C C8                    iny   
0531 227D C8                    iny   
0532 227E C8                    iny   
0533 227F D7 07                 cmp   [RPtr],y
0534 2281 10 0F                 bpl   YesEmpty
0535 2283 88                    dey   
0536 2284 88                    dey   
0537 2285 C0 04 00              cpy   #4
0538 2288 90 EF                 bcc   Loop
0539 228A
0540 228A A9 FF FF              lda   #TRUE                    ; put true in a-reg
0541 228D 85 0B        AllDone  sta   Result
0542 228F
0543 228F 4C 0E FC              jmp   EndCall4
0544 2292
0545 2292 A9 00 00     YesEmpty lda   #FALSE
0546 2295 80 F6                 bra   AllDone
0547 2297
0548 2297                       ENDP 
0549 2297
0550 2297              *****************************************************************
0551 2297              *
0552 2297              * Function Random : Integer
0553 2297              *
0554 2297              *  Basically, this is a transliteration of the 68000 random function in
0555 2297              *  QUICKDRAW done by Bill Atkinson.
0556 2297              *
0557 2297              *  REF:
0558 2297              *      "A More portable FORTRAN Random Number Generator"
0559 2297              *      by Linus Schrage
0560 2297              *      ACM Transactions on Mathematical Software
0561 2297              *      Volume 5, No. 2, June 1979, Pages 132-138
0562 2297              *
0563 2297              ***********************
0564 2297              *
0565 2297              * get low 16 bits of seed and form low product
0566 2297              * XALO:= A * LoWord(seed)
0567 2297              *
0568 2297              ***********************
0569 2297
0570 2297                       EXPORT Random 
0571 2297              Random   PROC 
0572 2297              OrigDirect equ 1 
0573 2297              RTL1     equ OrigDirect+2 
0574 2297              RTL2     equ RTL1+3 
0575 2297              Result   equ RTL2+3 
0576 2297
0577 2297 20 AA 0F              jsr   QDStart
0578 229A 7B                    tdc   
0579 229B 18                    clc   
0580 229C 69 00 01              adc   #256                     ; we only use the high page
0581 229F 5B                    tcd   
0582 22A0
0583 22A0 48                    pha                            ; space for result
0584 22A1 48                    pha   
0585 22A2 A5 00 48              PushWord RandSeed              ; LoWord(seed)     {multiplier}
0586 22A5 F4 A7 41              PushWord #16807                ; A=7**5           {multiplicand}
0587 22A8 A2 0B 09 22           _Multiply                      ; 1,S & 3,S = XALO {result}
0588 22AF              *
0589 22AF              * Form 31 Highest bits of Low Product
0590 22AF              * FHI := HiWord(seed) * A + HiWord(XALO)
0591 22AF              *
0592 22AF 48                    pha                            ; space for result
0593 22B0 48                    pha   
0594 22B1 A5 02 48              PushWord RandSeed+2            ; HiWord(seed)     {multiplier}
0595 22B4 F4 A7 41              PushWord #16807                ; A=7**5           {multiplicand}
0596 22B7 A2 0B 09 22           _Multiply                      ; 1,S & 3,S = PROD {result}
0597 22BE              *		 ; NOTE: XALO now at 5,S & 7,S
0598 22BE              *
0599 22BE A3 01                 lda   1,s                      ;        [PROD]
0600 22C0 18                    clc   
0601 22C1 63 07                 adc   7,s                      ; plus   [XALO+2] {hiWord(XALO)}
0602 22C3 83 01                 sta   1,s                      ; equals [FHI]
0603 22C5
0604 22C5 A3 03                 lda   3,s                      ;        [PROD+2]
0605 22C7 69 00 00              adc   #0                       ; plus   0
0606 22CA 83 03                 sta   3,s                      ; equals [FHI+2]
0607 22CC              *
0608 22CC              * Get Overflow past	31st bit of full product
0609 22CC              * K := FHI DIV 32768
0610 22CC              *
0611 22CC A3 01                 lda   1,s                      ;      [FHI]
0612 22CE 18                    clc   
0613 22CF 63 01                 adc   1,s                      ; plus [FHI]
0614 22D1
0615 22D1 A3 03                 lda   3,s                      ;      [FHI+2]
0616 22D3 63 03                 adc   3,s                      ; plus [FHI+2]
0617 22D5 AA                    tax                            ; equals K {store in X}
0618 22D6              *			; NOTE: use K as HiWord
0619 22D6              *
0620 22D6              * Assemble all of the parts and pre-subtract P
0621 22D6              * Seed := (BitAnd(XALO,#0000FFFF)-P) + BitAnd(FHI,$00007FFF)*B16 +K
0622 22D6              *
0623 22D6 A3 05                 lda   5,s                      ; [XALO]
0624 22D8 38                    sec   
0625 22D9 E9 FF FF              sbc   #$FFFF                   ; minus P = #$7FFFFFFF
0626 22DC 85 00                 sta   RandSeed                 ; temporarily
0627 22DE
0628 22DE A9 00 00              lda   #0
0629 22E1 E9 FF 7F              sbc   #$7FFF
0630 22E4 85 02                 sta   RandSeed+2
0631 22E6
0632 22E6 A3 01                 lda   1,s                      ; [FHI]
0633 22E8 29 FF 7F              and   #$7FFF
0634 22EB 18                    clc   
0635 22EC 65 02                 adc   RandSeed+2
0636 22EE 85 02                 sta   RandSeed+2
0637 22F0 8A                    txa                            ; [K]
0638 22F1 18                    clc   
0639 22F2 65 00                 adc   RandSeed
0640 22F4 85 00                 sta   RandSeed
0641 22F6              *
0642 22F6              * If seed < 0 then seed + P
0643 22F6              *
0644 22F6 A5 02                 lda   RandSeed+2
0645 22F8 10 0F                 bpl   Update
0646 22FA A5 00                 lda   RandSeed
0647 22FC 18                    clc   
0648 22FD 69 FF FF              adc   #$FFFF
0649 2300
0650 2300 85 00                 sta   RandSeed
0651 2302 A5 02                 lda   RandSeed+2
0652 2304 69 FF 7F              adc   #$7FFF
0653 2307 85 02                 sta   RandSeed+2
0654 2309
0655 2309 A5 00        Update   lda   RandSeed                 ; this is the result
0656 230B C9 00 80              cmp   #$8000                   ; use 0 if -32768
0657 230E D0 03                 bne   NumOK
0658 2310 A9 00 00              lda   #0
0659 2313 FA           NumOK    plx                            ;get rid of extra stack stuff
0660 2314 FA                    plx   
0661 2315 FA                    plx   
0662 2316 FA                    plx   
0663 2317 83 09                 sta   Result,S                 ; result
0664 2319 4C EA FB              jmp   BusyEC0
0665 231C
0666 231C                       ENDP 
0667 231C
0668 231C              ****************************************************************
0669 231C              *
0670 231C              * SetRandSeed     (Value : Long Integer)
0671 231C              *
0672 231C              ****************************************************************
0673 231C                       EXPORT SetRandSeed 
0674 231C              SetRandSeed PROC 
0675 231C              OrigDirect equ 1 
0676 231C              RTL1     equ OrigDirect+2 
0677 231C              RTL2     equ RTL1+3 
0678 231C              Value    equ RTL2+3 
0679 231C
0680 231C 20 AA 0F              jsr   QDStart
0681 231F
0682 231F A2 00 01              ldx   #256
0683 2322 A3 09                 lda   Value,s
0684 2324 95 00                 sta   RandSeed,x
0685 2326
0686 2326 A3 0B                 lda   Value+2,s
0687 2328 95 02                 sta   RandSeed+2,x
0688 232A
0689 232A 4C 19 FC              jmp   BusyEC4
0690 232D
0691 232D                       ENDP 
0692 232D              ****************************************************************
0693 232D              *
0694 232D              * AddPt   (SrcPtPtr : Ptr; DestPtPtr : ptr);
0695 232D              *
0696 232D              ****************************************************************
0697 232D                       EXPORT AddPt 
0698 232D              AddPt    PROC 
0699 232D              *              using CoreDATA
0700 232D              RTL1     equ 1 
0701 232D              RTL2     equ RTL1+3 
0702 232D              DestPtPtr equ RTL2+3 
0703 232D              SrcPtPtr equ DestPtPtr+4 
0704 232D
0705 232D
0706 232D
0707 232D
0708 232D 3B                    tsc                            ; get stack
0709 232E 0B                    phd                            ; save direct
0710 232F 5B                    tcd                            ; and so on...
0711 2330
0712 2330 A0 02 00              ldy   #2
0713 2333
0714 2333 B7 0B        Loop     lda   [SrcPtPtr],y
0715 2335 18                    clc   
0716 2336 77 07                 adc   [DestPtPtr],y
0717 2338 97 07                 sta   [DestPtPtr],y
0718 233A 88                    dey   
0719 233B 88                    dey   
0720 233C 10 F5                 bpl   Loop
0721 233E
0722 233E 4C 3A FC              jmp   EndCall8
0723 2341
0724 2341                       ENDP 
0725 2341
0726 2341              ****************************************************************
0727 2341              *
0728 2341              * SubPt   (SrcPtPtr : Ptr; DestPtPtr : ptr);
0729 2341              *
0730 2341              ****************************************************************
0731 2341                       EXPORT SubPt 
0732 2341              SubPt    PROC 
0733 2341              *              using CoreDATA
0734 2341              RTL1     equ 1 
0735 2341              RTL2     equ RTL1+3 
0736 2341              DestPtPtr equ RTL2+3 
0737 2341              SrcPtPtr equ DestPtPtr+4 
0738 2341
0739 2341
0740 2341
0741 2341
0742 2341 3B                    tsc                            ; get stack
0743 2342 0B                    phd                            ; save direct
0744 2343 5B                    tcd                            ; and so on...
0745 2344
0746 2344 A0 02 00              ldy   #2
0747 2347 B7 07        Loop     lda   [DestPtPtr],y
0748 2349 38                    sec   
0749 234A F7 0B                 sbc   [SrcPtPtr],y
0750 234C 97 07                 sta   [DestPtPtr],y
0751 234E 88                    dey   
0752 234F 88                    dey   
0753 2350 10 F5                 bpl   Loop
0754 2352
0755 2352 4C 3A FC              jmp   EndCall8
0756 2355
0757 2355                       ENDP 
0758 2355
0759 2355
0760 2355
0761 2355
0762 2355              ****************************************************************
0763 2355              *
0764 2355              * SetPt (PPtr : ptr; h,v integer);
0765 2355              *
0766 2355              * Parameters
0767 2355              *      input     long     PPtr
0768 2355              *      input     word     h
0769 2355              *      input     word     v
0770 2355              *
0771 2355              * This is one of the glue routines used by
0772 2355              * pascal programers.
0773 2355              *
0774 2355              ****************************************************************
0775 2355                       EXPORT SetPt 
0776 2355              SetPt    PROC 
0777 2355              RTL1     equ 1 
0778 2355              RTL2     equ RTL1+3 
0779 2355              V        equ RTL2+3 
0780 2355              H        equ V+2 
0781 2355              PPtr     equ H+2 
0782 2355
0783 2355 3B                    tsc                            ; get stack
0784 2356 0B                    phd                            ; save d
0785 2357 5B                    tcd                            ; set stack to zp
0786 2358
0787 2358 A5 07                 lda   V
0788 235A 87 0B                 sta   [PPtr]
0789 235C A0 02 00              ldy   #2
0790 235F A5 09                 lda   H
0791 2361 97 0B                 sta   [PPtr],y
0792 2363
0793 2363 4C 3A FC              jmp   EndCall8
0794 2366
0795 2366                       ENDP 
0796 2366
0797 2366
0798 2366
0799 2366
0800 2366
0801 2366              ****************************************************************
0802 2366              *
0803 2366              * EqualPt (p1ptr,p2ptr : ptr) : boolean
0804 2366              *
0805 2366              * Params
0806 2366              *      input     long   P1 Pointer
0807 2366              *      input     long   P2 Pointer
0808 2366              *      output    word?  boolean
0809 2366              *
0810 2366              ****************************************************************
0811 2366                       EXPORT EqualPt 
0812 2366              EqualPt  PROC 
0813 2366              *              using CoreDATA
0814 2366              RTL1     equ 1 
0815 2366              RTL2     equ RTL1+3 
0816 2366              P1Ptr    equ RTL2+3 
0817 2366              P2Ptr    equ P1Ptr+4 
0818 2366              Result   equ P2Ptr+4 
0819 2366
0820 2366 3B                    tsc   
0821 2367 0B                    phd   
0822 2368 5B                    tcd   
0823 2369
0824 2369 A0 02 00              ldy   #2
0825 236C B7 07        Loop     lda   [P1Ptr],y
0826 236E D7 0B                 cmp   [P2Ptr],y
0827 2370 D0 0C                 bne   NotEqual
0828 2372 88                    dey   
0829 2373 88                    dey   
0830 2374 10 F6                 bpl   Loop
0831 2376
0832 2376 A9 FF FF              lda   #TRUE
0833 2379 85 0F        ReportResult sta   Result
0834 237B
0835 237B 4C 3A FC              jmp   EndCall8
0836 237E
0837 237E A9 00 00     NotEqual lda   #FALSE
0838 2381 80 F6                 bra   ReportResult
0839 2383
0840 2383                       ENDP 
0841 2383
0842 2383
0843 2383
0844 2383
0845 2383              ****************************************************************
0846 2383              *
0847 2383              * LocalToGlobal  (PPtr : Ptr);
0848 2383              *
0849 2383              * Params
0850 2383              *      input      long    P Pointer
0851 2383              *
0852 2383              * Modifications
0853 2383              *
0854 2383              *     April 7, 1986    Makes BusyEC4 call to terminate
0855 2383              *
0856 2383              ****************************************************************
0857 2383                       EXPORT LocalToGlobal 
0858 2383              LocalToGlobal PROC 
0859 2383              *              using CoreDATA
0860 2383              OrigDirect equ 1 
0861 2383              RTL1     equ OrigDirect+2 
0862 2383              RTL2     equ RTL1+3 
0863 2383              PPtr     equ RTL2+3 
0864 2383
0865 2383 20 AA 0F              jsr   QDStart
0866 2386
0867 2386 A3 09                 lda   PPtr,s
0868 2388 AA                    tax   
0869 2389 A3 0A                 lda   PPtr+1,s
0870 238B 8B                    phb                            ;save bank
0871 238C 48                    pha   
0872 238D AB                    plb   
0873 238E AB                    plb                            ; set bank
0874 238F
0875 238F BD 00 00              lda   |0,x
0876 2392 38                    sec   
0877 2393 A0 08 00              ldy   #o_BoundsRect
0878 2396 F7 24                 sbc   [PortRef],y
0879 2398 9D 00 00              sta   |0,x
0880 239B
0881 239B BD 02 00              lda   |2,x
0882 239E 38                    sec   
0883 239F C8                    iny   
0884 23A0 C8                    iny   
0885 23A1 F7 24                 sbc   [PortRef],y
0886 23A3 9D 02 00              sta   |2,x
0887 23A6
0888 23A6 AB                    plb                            ; restore bank
0889 23A7
0890 23A7 4C 19 FC              jmp   BusyEC4
0891 23AA
0892 23AA                       ENDP 
0893 23AA
0894 23AA
0895 23AA              ****************************************************************
0896 23AA              *
0897 23AA              * GlobalToLocal (PPtr : Ptr);
0898 23AA              *
0899 23AA              * Params
0900 23AA              *       input     long   P Pointer
0901 23AA              *
0902 23AA              * Modifications
0903 23AA              *
0904 23AA              *     April 7, 1986    Makes BusyEC4 call to terminate
0905 23AA              *
0906 23AA              ****************************************************************
0907 23AA                       EXPORT GlobalToLocal 
0908 23AA              GlobalToLocal PROC 
0909 23AA              *              using CoreDATA
0910 23AA              OrigDirect equ 1 
0911 23AA              RTL1     equ OrigDirect+2 
0912 23AA              RTL2     equ RTL1+3 
0913 23AA              PPtr     equ RTL2+3 
0914 23AA
0915 23AA 20 AA 0F              jsr   QDStart
0916 23AD
0917 23AD A3 09                 lda   PPtr,s
0918 23AF AA                    tax   
0919 23B0 A3 0A                 lda   PPtr+1,s
0920 23B2 8B                    phb                            ;save bank
0921 23B3 48                    pha   
0922 23B4 AB                    plb   
0923 23B5 AB                    plb                            ; set bank
0924 23B6
0925 23B6 BD 00 00              lda   |0,x
0926 23B9 18                    clc   
0927 23BA A0 08 00              ldy   #o_BoundsRect
0928 23BD 77 24                 adc   [PortRef],y
0929 23BF 9D 00 00              sta   |0,x
0930 23C2
0931 23C2 BD 02 00              lda   |2,x
0932 23C5 18                    clc   
0933 23C6 C8                    iny   
0934 23C7 C8                    iny   
0935 23C8 77 24                 adc   [PortRef],y
0936 23CA 9D 02 00              sta   |2,x
0937 23CD
0938 23CD AB                    plb   
0939 23CE 4C 19 FC     AllDone  jmp   BusyEC4
0940 23D1
0941 23D1                       ENDP 
0942 23D1
0943 23D1
0944 23D1
0945 23D1              ****************************************************************
0946 23D1              *
0947 23D1              * GetPixel (Hor, Vert : integer) : integer
0948 23D1              *
0949 23D1              ****************************************************************
0950 23D1                       EXPORT GetPixel 
0951 23D1              GetPixel PROC 
0952 23D1              *              using CoreDATA
0953 23D1              *              using E0Vectors
0954 23D1
0955 23D1              OrigDirect equ 1 
0956 23D1              RTL1     equ OrigDirect+2 
0957 23D1              RTL2     equ RTL1+3 
0958 23D1              Vert     equ RTL2+3 
0959 23D1              Hor      equ Vert+2 
0960 23D1              Result   equ Hor+2 
0961 23D1
0962 23D1 20 AA 0F              jsr   QDStart
0963 23D4
0964 23D4 22 3C 1E E0           jsl   PortLoc2ZP               ; get port stuff
0965 23D8
0966 23D8              ;---------------------------------------------------
0967 23D8              ;
0968 23D8              ; Convert Vert to global coordinates and multiply
0969 23D8              ; by width.
0970 23D8 48                    pha                            ; space for result
0971 23D9 48                    pha   
0972 23DA A3 0D                 lda   Vert+4,s
0973 23DC 38                    sec   
0974 23DD E5 14                 sbc   BoundsRect
0975 23DF 48                    pha   
0976 23E0 A5 12                 lda   Width
0977 23E2 48                    pha   
0978 23E3 A2 0B 09 22           _Multiply 
0979 23EA
0980 23EA              ;---------------------------------------------------
0981 23EA              ;
0982 23EA              ; Leave the result on the stack a minute and convert
0983 23EA              ; horizontal coordinates to global and then to a
0984 23EA              ; byte number.
0985 23EA              ;
0986 23EA A3 0F                 lda   Hor+4,s
0987 23EC 38                    sec   
0988 23ED E5 16                 sbc   BoundsRect+2
0989 23EF 4A                    lsr   a                        ; convert to byte number
0990 23F0 24 0B                 bit   PortSCB-1
0991 23F2 10 01                 bpl   Mode320
0992 23F4 4A                    lsr   a
0993 23F5 18           Mode320  clc   
0994 23F6 63 01                 adc   1,s                      ; add to Vert * Width
0995 23F8 A8                    tay                            ; put in y
0996 23F9
0997 23F9 68                    pla                            ; pull result of earlier multiply
0998 23FA 68                    pla                            ; off the stack
0999 23FB
1000 23FB
1001 23FB              ;---------------------------------------------------
1002 23FB              ;
1003 23FB              ; Now we have index to byte in pixel map in y. We
1004 23FB              ; must figure how far we'll shift the resulting
1005 23FB              ; byte to get desired pixel in lowest bits of
1006 23FB              ; pixel.
1007 23FB              ;
1008 23FB A3 0B                 lda   Hor,s
1009 23FD 38                    sec   
1010 23FE E5 16                 sbc   BoundsRect+2
1011 2400 24 0B                 bit   PortSCB-1
1012 2402 30 09                 bmi   DoMode640
1013 2404
1014 2404              ;---------------------------------------------------
1015 2404              ;
1016 2404              ; For Mode320, the pixel is either odd or even.
1017 2404              ; If it is even we must shift it from the high nibble
1018 2404              ; to the low nibble.  If it is odd, we do not shift
1019 2404              ; it at all.
1020 2404              ;
1021 2404 29 01 00              and   #1                       ; decide if odd or even
1022 2407 49 01 00              eor   #1                       ; invert result
1023 240A 0A                    asl   a                        ; double this so 1 becomes 2
1024 240B 80 06                 bra   ShiftIt                  ; go on and shift
1025 240D
1026 240D
1027 240D              ;---------------------------------------------------
1028 240D              ;
1029 240D              ; For Mode640, the pixel is in one of four positions:
1030 240D              ; zero thru three. If position is zero, then must
1031 240D              ; shift it down three pixels (6 bits).  If it is three
1032 240D              ; we do not shift it.
1033 240D              ;
1034 240D 29 03 00     DoMode640 and   #3
1035 2410 49 03 00              eor   #3
1036 2413
1037 2413 AA           ShiftIt  tax   
1038 2414 B7 0E                 lda   [ImageRef],y             ; get the byte
1039 2416
1040 2416 E0 00 00     ShiftLoop cpx   #0
1041 2419 F0 05                 beq   FinishIt
1042 241B 4A                    lsr   a
1043 241C 4A                    lsr   a
1044 241D CA                    dex   
1045 241E 80 F6                 bra   ShiftLoop
1046 2420
1047 2420 24 0B        FinishIt bit   PortSCB-1
1048 2422 10 05                 bpl   MaskMode320
1049 2424 29 03 00              and   #%00000011
1050 2427 80 03                 bra   PutResult
1051 2429
1052 2429 29 0F 00     MaskMode320 and   #$0F
1053 242C
1054 242C 83 0D        PutResult sta   Result,s
1055 242E
1056 242E 4C 19 FC              jmp   BusyEC4
1057 2431
1058 2431
1059 2431                       ENDP 
1060 2431              ;                COPY utils/scale
1061 2431              ****************************************************************
1062 2431              *
1063 2431              * ScalePt
1064 2431              *
1065 2431              *     PtPtr   : long
1066 2431              *     SrcRectPtr : long
1067 2431              *     DestRectPtr : long
1068 2431              *
1069 2431              *
1070 2431              *                 DestRectPtr^.Bottom - DestRectPtr^.Top
1071 2431              *     PtPtr^.v := --------------------------------------  * PtPtr^.v
1072 2431              *                 SrcRectPtr^.Bottom-SrcRectPtr^.Top
1073 2431              *
1074 2431              *                 DestRectPtr^.Right - DestRectPtr^.Left
1075 2431              *     PtPtr^.h := --------------------------------------  * PtPtr^.h
1076 2431              *                 SrcRectPtr^.Right-SrcRectPtr^.Left
1077 2431              *
1078 2431              *
1079 2431              *
1080 2431              ****************************************************************
1081 2431                       EXPORT ScalePt 
1082 2431              ScalePt  PROC 
1083 2431
1084 2431              OrigDirect equ 1 
1085 2431              AFlag    equ OrigDirect+2 
1086 2431              Sign     equ AFlag+2 
1087 2431              RTL1     equ Sign+2 
1088 2431              RTL2     equ RTL1+3 
1089 2431              DestRectPtr equ RTL2+3 
1090 2431              SrcRectPtr equ DestRectPtr+4 
1091 2431              PtPtr    equ SrcRectPtr+4 
1092 2431
1093 2431
1094 2431 F4 00 00              pea   0                        ; put this flag on stack to 
1095 2434              *			; indicate that this is first time thru
1096 2434 F4 00 00              pea   0                        ; put this word on stack as indicator
1097 2437              *			; of sign
1098 2437 0B                    phd   
1099 2438 3B                    tsc   
1100 2439 5B                    tcd   
1101 243A
1102 243A A9 00 00     Loop     lda   #0                       ; make room for the long divide result
1103 243D 48                    pha                            ; needed later
1104 243E 48                    pha   
1105 243F 48                    pha   
1106 2440 48                    pha   
1107 2441
1108 2441 48                    pha                            ; make room for multiply 
1109 2442 48                    pha   
1110 2443
1111 2443 A0 04 00              ldy   #4
1112 2446 B7 0D                 lda   [DestRectPtr],y
1113 2448 38                    sec   
1114 2449 E7 0D                 sbc   [DestRectPtr]
1115 244B 10 06                 bpl   NotNeg1
1116 244D 49 FF FF              eor   #$FFFF
1117 2450 1A                    inc   a
1118 2451 E6 05                 inc   Sign
1119 2453 48           NotNeg1  pha   
1120 2454
1121 2454 A7 15                 lda   [PtPtr]
1122 2456 10 06                 bpl   NotNeg2
1123 2458 49 FF FF              eor   #$FFFF
1124 245B 1A                    inc   a
1125 245C E6 05                 inc   Sign
1126 245E 48           NotNeg2  pha   
1127 245F
1128 245F A2 0B 09 22           _Multiply 
1129 2466
1130 2466              ;---------------------------------------
1131 2466              ; 
1132 2466              ; The stack looks like this
1133 2466              ;
1134 2466              ;        long (result of divide that we are about to do)
1135 2466              ;        word (hi word of mulitply result)
1136 2466              ;        word (low word of multiply result)
1137 2466              ;        tos
1138 2466
1139 2466 A0 04 00              ldy   #4
1140 2469 B7 11                 lda   [SrcRectPtr],y
1141 246B 38                    sec   
1142 246C E7 11                 sbc   [SrcRectPtr]
1143 246E 10 06                 bpl   NotNeg3
1144 2470 49 FF FF              eor   #$FFFF
1145 2473 1A                    inc   a
1146 2474 E6 05                 inc   Sign
1147 2476 F4 00 00     NotNeg3  pea   0
1148 2479 48                    pha   
1149 247A
1150 247A A2 0B 0D 22           _LongDivide 
1151 2481 68                    pla                            ; this is result we want
1152 2482 FA                    plx                            ; these are all ignored
1153 2483 FA                    plx   
1154 2484 FA                    plx   
1155 2485
1156 2485 46 05                 lsr   Sign                     ; if Sign is 1 or 3 then have
1157 2487 90 04                 bcc   Even                     ; odd number of negative numbers
1158 2489
1159 2489 49 FF FF              eor   #$FFFF                   ; so result is negative.  if Sign
1160 248C 1A                    inc   a                        ; is 0 or 2 then have even number of
1161 248D              *			; neg numbers
1162 248D 87 15        Even     sta   [PtPtr]
1163 248F
1164 248F
1165 248F A5 03                 lda   AFlag
1166 2491 D0 37                 bne   AllDone
1167 2493
1168 2493 C6 03                 dec   AFlag                    ; next time we'll fall thru
1169 2495 A5 15 A6 17           BumpLongBy2 PtPtr              ; bump these pointers so same code
1170 24A5 A5 11 A6 13           BumpLongBy2 SrcRectPtr         ; works with H.
1171 24B5 A5 0D A6 0F           BumpLongBy2 DestRectPtr 
1172 24C5 64 05                 stz   Sign                     ; reset sign
1173 24C7 4C 3A 24              jmp   Loop
1174 24CA
1175 24CA 2B           AllDone  pld   
1176 24CB 68                    pla                            ; pull off flag word
1177 24CC 68                    pla                            ; pull off sign word
1178 24CD 4C 65 FC              jmp   oEndCall12
1179 24D0
1180 24D0                       ENDP 
1181 24D0
1182 24D0
1183 24D0
1184 24D0                       END   
